@ECHO OFF
REM %1 = source drive letter;  %2 = source version (eg. GSMS1V20); %3 = target version  %4 = kB free
ECHO %0 %1 %2 %3 %4 >> c:\install.log
ECHO preparing system...
IF NOT EXIST C:\CMU\nul MD C:\CMU
IF NOT EXIST C:\CMU\UTILS\nul MD C:\CMU\UTILS

ATTRIB -R /S C:\CMU\%3\*.*      >> c:\install.log
ATTRIB -R /S C:\CMU\UTILS\*.*   >> c:\install.log
ATTRIB -R /S C:\CMU\DATA\*.*    >> c:\install.log
ATTRIB -R /S C:\CMU\TABLES\*.*  >> c:\install.log
ATTRIB -R    C:\*.*             >> c:\install.log

REM test if CMU software has been installed at least once
IF EXIST C:\CMU\DOS_SAVE.CNF\CONFIG.SYS GOTO NotFirstInst

REM create backup directory if not done yet
IF NOT EXIST C:\CMU\DOS_SAVE.CNF\nul MD C:\CMU\DOS_SAVE.CNF

ECHO Backup of configuration files >> c:\install.log
IF EXIST C:\CONFIG.SYS   COPY C:\CONFIG.SYS   C:\CMU\DOS_SAVE.CNF\.
IF EXIST C:\AUTOEXEC.BAT COPY C:\AUTOEXEC.BAT C:\CMU\DOS_SAVE.CNF\.
IF EXIST C:\AUTOCONF.BAT COPY C:\AUTOCONF.BAT C:\CMU\DOS_SAVE.CNF\.

REM save batch file to restore configuration
COPY %1\%2\RECONF.BAT C:\CMU\UTILS\.
REM for extra fun make more than one
COPY %1\%2\RECONF.BAT C:\CMU\DOS_SAVE.CNF\.



:NotFirstInst
REM create new version directory, if not done yet
IF NOT EXIST C:\CMU\%3\nul MD C:\CMU\%3

REM don't copy the 'CONFIG.INI' to the target
rem COPY %1\%2\CONFIG.INI C:\CMU\%3\.

REM copy untgz386.exe to UTILS
ECHO copy files to the CMU ...
IF EXIST %1\%2\UNTGZ.EXE COPY %1\%2\UNTGZ.EXE C:\CMU\UTILS\. >> c:\install.log
IF NOT EXIST C:\CMU\UTILS\UNTGZ.EXE GOTO NoVerChange

REM call installation program
IF NOT EXIST %1\%2\ARCHIV.EXE GOTO NoArchiv.exe
%1\%2\ARCHIV.EXE


REM test if archive is OK
IF NOT EXIST C:\CMU\UTILS\UNTGZ.EXE NoUntgz.exe
UNTGZ.EXE -t C:\TEMP.TAR\ARCHIV.TGZ >> c:\install.log
IF ERRORLEVEL 1 GOTO NoVerChange

REM UNPACK FILES
ECHO extracting files ...
C:
CD C:\CMU\%3
UNTGZ.EXE -y C:\TEMP.TAR\ARCHIV.TGZ >> c:\install.log

REM test if installation failed
IF ERRORLEVEL 1 GOTO NoVerChange

DELTREE /Y C:\TEMP.TAR >> c:\install.log

REM Patch the Bootsector (first error code is not interesting.)
C:\CMU\UTILS\instboot c: /r >> c:\install.log
C:\CMU\UTILS\instboot c: >> c:\install.log
if errorlevel 1 goto NoVerChange

setvname C:\CMU\%3\CONFIG %3

REM now copy startup pictures:
XCOPY C:\CMU\%3\CONFIG\*.PCX C:\CMU\. /Y >> c:\install.log

REM now change the version to DOS
XCOPY C:\CMU\%3\CONFIG\*.* C:\. /S /E /Y >> c:\install.log

REM delete NVL
IF EXIST C:\CMU\%3\BASE\BSW\EXE\nvl*.dat DEL C:\CMU\%3\BASE\BSW\EXE\nvl*.dat >> C:\install.log
nvltool c >> c:\install.log

rem delete C:\NOFWUPD.TXT to trigger a FW-Update at next reboot
IF EXIST C:\NOFWUPD.TXT DEL C:\NOFWUPD.TXT

rem calculate the kB_Need of the new Version
IF EXIST C:\CMU\UTILS\CALC_KB.EXE C:\CMU\UTILS\CALC_KB.EXE C:\CMU\%3 %4

CLS
ECHO.
ECHO installation completed
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
rem PAUSE

DEL c:\install.log
ECHO Firstfree=%4> C:\UPGDMORE.TXT
ECHO This file is generated automatically to make some more upgrades without backing up the whole version.>> C:\UPGDMORE.TXT
ECHO Please do not change this file>> C:\UPGDMORE.TXT

IF EXIST C:\CMU\%3\INCOMPL.VER DEL C:\CMU\%3\INCOMPL.VER

IF EXIST C:\CMU\UTILS\SYNC.COM C:\CMU\UTILS\SYNC.COM
IF EXIST C:\CMU\UTILS\RESET.COM C:\CMU\UTILS\RESET.COM

rem Booting failed ?
GOTO End

:NoArchiv.exe
ECHO ARCHIV.EXE is missing.
ECHO.
GOTO NoVerChange

:NoUntgz.exe
ECHO UNTGZ.EXE is missing.
ECHO.
DELTREE /Y C:\TEMP.TAR >> c:\install.log
GOTO NoVerChange

:NoVerChange
ECHO an error occurred during software installation.
ECHO Software version has not been changed.
ECHO.
PAUSE


:End


